Hooks:PostHook( BlackMarketTweakData, "_init_player_styles", "LegendaryArmourSkins_LoadOutfits", function(self)
	local base_replacement_standard = {
		head = false,
		armor = false,
		body = false,
		hands = false,
		vest = false
	}

	local base_replacement_all = {
		head = true,
		armor = true,
		body = true,
		hands = true,
		vest = true
	}

	for name, data in pairs( LegendaryArmours ) do
		key = "las_" .. name

		local function remap_variables(data)
			local output = {}

			output.unit = data.fps_unit
			output.third_unit = data.unit

			if data.unit_material or data.fps_unit_material then
				output.material_variations = {}
				output.material_variations.default = {}
				output.material_variations.default.custom = true
				output.material_variations.default.third_material = data.unit_material
				output.material_variations.default.material = data.fps_unit_material
			end

			output.name_id = data.name_id or "bm_askn_" .. name
			output.desc_id = data.desc_id or "bm_askn_" .. name .. "_desc"

			output.unlocked = true
			output.auto_aquire = true
			output.custom = true
			output.texture_bundle_folder = data.category or "heist_outfits"

			if data.hide_armor or data.replace_body or data.replace_all then
				output.body_replacement = clone(base_replacement_standard)
			end

			if data.fps_hide_armor or data.fps_replace_body or data.fps_replace_all then
				output.third_body_replacement = clone(base_replacement_standard)
			end

			if data.hide_armor then
				output.third_body_replacement.armor = true
				output.third_body_replacement.vest = true
			end

			if data.replace_body then
				output.third_body_replacement.body = true
				output.third_body_replacement.hands = true
			end

			if data.replace_all then
				output.third_body_replacement = base_replacement_all
			end

			if data.fps_hide_armor then
				output.body_replacement.armor = true
				output.body_replacement.vest = true
			end

			if data.fps_replace_body then
				output.body_replacement.body = true
				output.body_replacement.hands = true
			end

			if data.fps_replace_all then
				output.body_replacement = base_replacement_all
			end

			if data.character_override then
				output.characters = {}

				for character_id, character_data in pairs(data.character_override) do
					output.characters[character_id] = remap_variables(character_data)
				end
			end

			return output
		end

		self.player_styles[key] = remap_variables(data)
	end
end)